
; DEVEL-MODE
; DEBUG-MODE
; VERBOSE-MODE
; each of these has an optional argument which can be t or nil. 
; if used, sets mode. if not used, toggles mode.

#|
 | DEVELOPER TOOLS (SUCH AS THEY ARE)
 |#


(defun user-mode ()
  (set-devel-mode nil)
  (setf *pro-version* nil)
  (setf *user-mode* t))

(defun developer-mode () (devel-mode :silent t))


(defun developers-mode (&optional (logical nil set) &key silent)
"Args: (&optional (logical nil set))
Sets developers mode to LOGICAL, if used, or toggles developers mode from t to nil or from nil to t if LOGICAL not used. When in developers mode *debug-mode*, *breakenable*, *tracenable* and *devel-mode* are t, *user-mode* is nil, *tracelimit* is 2, and the graphics and developers menus are shown; conversely when not in developer's mode. The first time the function is used the developers mode menu item is added to the options menu. It is not removed until exiting."
  (when set (setf *devel-mode* (not logical)))
  (toggle-devel-mode)
  (setf *user-mode* (not *devel-mode*))
  (send devel-item :mark *devel-mode*))

(defun devel-mode (&optional (logical nil set) &key silent)
"Args: (&optional (logical nil set))
Sets developers mode to LOGICAL, if used, or toggles developers mode from t to nil or from nil to t if LOGICAL not used. When in developers mode *debug-mode*, *breakenable*, *tracenable* and *devel-mode* are t, *user-mode* is nil, *tracelimit* is 2, and the graphics and developers menus are shown; conversely when not in developer's mode. The first time the function is used the developers mode menu item is added to the options menu. It is not removed until exiting."
  (when set (setf *devel-mode* (not logical)))
  (toggle-devel-mode)
  (setf *user-mode* (not *devel-mode*))
  (send devel-item :mark *devel-mode*))

(defun devel-toggle ()
"Args &key set-verbose
Toggles developer-mode. This toggles *devel-mode* *pro-version* *breakenable* *tracenable* *debug-mode*, and when verbose sets *v* *verbose* *search-verbose* *load-verbose* *file-verbose* *visible-startup* and *container-verbose* to the value of *debug-mode*."
  (if *devel-mode* (set-devel-mode nil t) (set-devel-mode t t))
  (when verbose (verbose *devel-mode*)))

(defun toggle-devel-mode ()
  (set-devel-mode (not (set-devel-mode))))

(defun set-devel-mode (&optional (nilt nil used?) verbose)
  (when used?
        (if nilt
            (set-user-privileges "Developer")
            (set-user-privileges *user-type*))
        (setf *pro-version* t)
        (setf *devel-mode* nilt)
        (setf *breakenable* nilt)
        (setf *tracenable* nilt)
        (setf *tracelimit* (if nilt 2 nil))
        (unless (or *make-time* *initial-install* (< *run-number* 0)) 
                (set-devel-mode-menus nilt))
        (debug-mode *devel-mode*)
	(set-vista-pro-version );new fwy 9-3-02
	(save-every-pref-file))
  *devel-mode*)


(defun set-devel-mode-menus (nilt)
  (enable-container *desktop-container*)
  (send *devel-menu*    (if nilt :install :remove))
  (send *graphics-menu* (if nilt :install :remove))
  (menus nil)
  (menus t)
  (disable-container)
  (setf *show-devel-menu* nilt)
  (send devel-item :mark nilt)
  (send *command-menu* :update-items)
  (send command-menu-developers-item :mark nilt)
  ;(menus t)
  )


(defun read-devel-files ()
  (let ((file-list (directory (strcat *devel-dir-name* "*.lsp"))))
    (when file-list
          (mapcar #'(lambda (file) 
                      (gc) 
                      (load file))
                  (sort-data file-list))
          )))

#|
(defun verbose (&optional (logical nil l-set) (file-name nil set));was (file-name nil set)
"Args: (logical &optional (file-name nil set))
Reports value of *verbose*. If LOGICAL is used, turns verbose mode on or off depending on value of LOGICAL. Verbose mode sets the variables *v* *verbose* *search-verbose* *load-verbose* *file-verbose* *visible-startup* and *container-verbose*. 
  FILE-NAME ignored if LOGICAL is nil. Otherwise: If FILE-NAME is not used, creates no file. If FILE-NAME is t, creates file lognnnn.log, where nnnn is the next log number. If FILE-NAME is a string, creates file FILE-NAME. Thus
(verbose t) turns verbose mode on and creates no file
(verbose nil) turns verbose mode off
(verbose t \"build.log\" turns verbose mode on and creates file build.log
(verbose t t) turns verbose mode on and creates file lognnnn.log"
  (cond
    ((not l-set) 
     (format t "; verbose mode is ~d~%" (if *verbose* "on" "off"))
     *verbose*)
    (logical
     (unless *make-time*
             (format t "; verbose mode ~a on~%" (if *verbose* "remains" "turned"))
             (if *verbose-file-open*
                 (format t "; logfile ~a is open~%" *verbose-file-open*)
                 (when (not set)
                       (format t "; logfile not opened. to open, type (verbose t t)~%"))))
     (cond
       (*make-time*); ((not *vista*))
       ((or file-name (stringp file-name)) 
        (cond
          ((and *verbose-file-open* (not (stringp file-name)))
           (format t "; logfile remains open~%"))
          
          (t
           (when *verbose-file-open* 
                 (format t "; currently open verbose file will be closed.")
                 (double-dribble))
           (set-working-directory *default-path*)
           (unless (stringp file-name) (setf file-name (get-next-log-filename)))
           (double-dribble file-name)
           (make-vista-copyright)
           (copyright)
           (setf *verbose-file-open* file-name)
           (format t "~2%; opened logfile ~a~a~%" *default-path* file-name)
           (format t "; opened logfile on ~a, at ~a. Opened by (verbose t t)~2%" 
                   (first (date-time)) (second (date-time)))))))
     (setf *v* t)
     (setf *verbose* t)
     (setf *search-verbose* t)
     (setf *load-verbose* t)
     (setf *file-verbose* t)
     (setf *log-verbose* t)
     (format t "; these verbose flags were placed on:~%;     *v*, *verbose*, *search-verbose*, *log-verbose*, *load-verbose*, *file-verbose*~%; these verbose flags were unchanged:~%;     *container-verbose* (NIL), *baktracer-verbose* (T), *search-verbose* (~a),~%;     *statinit-verbose* (~a), *xlispverbose* (~a)~%" *container-verbose* *baktracer-verbose* *search-verbose* *statinit-verbose*  *xlispverbose*))
    (t
     (unless *make-time* 
             (format t "; verbose mode ~a off~%"
                     (if *verbose*  "turned" "remains")))
     (cond
       ((not *verbose*));asked to turn off and is already off
       (t ;asked to turn off and when it is on
          (when *verbose-file-open* 
                (let* ((now-file-name *verbose-file-open*)
                       )
                  (if (probe-file now-file-name)
                      (progn    
                       (double-dribble) ;closes drible file
                       (setf *verbose-file-open* nil)
                       (format t "; closed  ~a~%" now-file-name))
                      (unless *make-time* 
                              (format t "; could not find ~a~%" now-file-name)))))))
     (setf *v* nil)
     (setf *verbose* nil)
     (setf *search-verbose* nil)
     (setf *load-verbose* nil)
     (double-dribble)
     (setf *log-verbose* nil)))
  (when (not *make-time*)
        (write-verbose-file)
        (when *vista* (ignore-errors (send verbose-item :mark *verbose*))))
  (setf *file-verbose* *verbose*)
  *verbose*)
|#

(defun terse ()
"Turns verbose mode off"
  (verbose nil))

(defun verbose-toggle ()
  (cond 
    (*verbose*
     (verbose nil)
     (ignore-errors (send verbose-item :mark nil))
     (clean-up)
    ; (top-level nil)
     )
    (t
     (verbose t)
     (ignore-errors (send verbose-item :mark t))
     (clean-up)
     ;(top-level nil)
    ))
  (format t "; verbose toggle:  *verbose* set to ~d~%" *verbose*)
  )

(defun verbose-mode (&optional (logical nil set))
  (when set (setf *verbose* (not logical)))
  (verbose-toggle))

(setf *FILE-VERBOSE-FILE-OPEN* nil)

(defun file-verbose (&optional (logical nil l-set) (file-name nil set));was (file-name nil set)
"Args: (logical &optional (file-name nil set))
Reports value of *file-verbose*. If LOGICAL is used, turns file-verbose mode on or off depending on value of LOGICAL. file-Verbose mode sets the variables *file-verbose* and *load-verbose*. See (verbose) for a more general function. 
  FILE-NAME ignored if LOGICAL is nil. Otherwise: If FILE-NAME is not used, creates no file. If FILE-NAME is t, creates file lognnnn.log, where nnnn is the next log number. If FILE-NAME is a string, creates file FILE-NAME. Thus
(file-verbose t)   turns file-verbose mode on and creates no file
(file-verbose nil) turns file-verbose mode off
(file-verbose t   \"build.log\" turns file-verbose mode on and creates file build.log
(file-verbose t t) turns file-verbose mode on and creates file lognnnn.log"
  (cond
    ((not l-set) 
     (format t "; file-verbose mode is ~d~%" (if *file-verbose* "on" "off"))
     *file-verbose*)
    (logical
     (unless *make-time*
             (format t "; file-verbose mode ~a on~%" (if *file-verbose* "remains" "turned"))
             (if *file-verbose-file-open*
                 (format t "; logfile ~a is open~%" *file-verbose-file-open*)
                 (when (not set)
                       (format t "; logfile not opened. to open, type (verbose t t)~%"))))
     (cond
       (*make-time*); ((not *vista*))
       ((or file-name (stringp file-name)) 
        (cond
          ((and *file-verbose-file-open* (not (stringp file-name)))
           (format t "; logfile remains open~%"))
          
          (t
           (when *file-verbose-file-open* 
                 (format t "; currently open file-verbose file will be closed.")
                 (double-dribble))
           (set-working-directory *default-path*)
           (unless (stringp file-name) (setf file-name (get-next-log-filename)))
           (double-dribble file-name)
           (make-vista-copyright)
           (copyright)
           (setf *file-verbose-file-open* file-name)
           (format t "~2%; opened logfile ~a~a~%" *default-path* file-name)
           (format t "; opened logfile on ~a, at ~a. Opened by (file-verbose t t)~2%" 
                   (first (date-time)) (second (date-time)))))))
     (setf *load-verbose* t)
     (setf *file-verbose* t)
     (format t "; *file-verbose* ~a~%; *load-verbose* ~a~%" *file-verbose* *load-verbose*))
    (t
     (unless *make-time* 
             (format t "; file-verbose mode ~a off~%"
                     (if *file-verbose*  "turned" "remains")))
     (cond
       ((not *file-verbose*));asked to turn off and is already off
       (t ;asked to turn off and when it is on
          (when *file-verbose-file-open* 
                (let* ((now-file-name *file-verbose-file-open*)
                       ; (strcat *default-path* "log" 
                       ;         (format nil "~a" *log-number*) ".log")
                       )
                  (if (probe-file now-file-name)
                      (progn    
                       (double-dribble) ;closes drible file
                       (setf *file-verbose-file-open* nil)
                       (format t "; closed  ~a~%" now-file-name))
                      (unless *make-time* 
                              (format t "; could not find ~a~%" now-file-name)))))))
     (setf *file-verbose* nil)
     (setf *load-verbose* nil)
     (double-dribble)
     ))

  (when (not *make-time*)
        (write-verbose-file)
        (when *vista* (ignore-errors (send verbose-item :mark *verbose*)))
        )
  *file-verbose*)
  
(defun baktracer (&optional terse)
"Args: &optional terse
BacTrace Manager. Shows function name at each level. Commands are:
\n+ go to next baktrace level                q quit baktracer
\n- go back to previous baktrace level       h help about baktracer
\n> more details about this baktrace level   v verbose baktracer mode switch"
  (let ((i 0)
        (str "; Commands: + next      - previous  > more detail")
        (str2";           h help      q quit      v verbose\n"))
    (format t "~a~%~a~%" str str2)
    (loop
       (if (= i 0)
           (format t "top level > ")
           (format t "level ~d   > "i))
       (setf x (read ))
       (case x
         ('+ (setf i (1+ i)) (baktrace i nil))
         ('q (return))
         ('- (setf i (1- i)) (if (= i 0) (return) (baktrace i nil)))
         ('h (help 'baktracer))
         ('> (baktrace i ))
         ('v (setf *baktracer-verbose* (not *baktracer-verbose*))
             (when *baktracer-verbose* (format nil "~a" str)))
         ))))

